
//Title:       ITX Directory Administration
//Version:
//Copyright:   Copyright (c) 2000
//Author:      Indrayana Rustandi
//Company:     Columbia University, Computer Science Department
//Description:
package edu.columbia.cs.itx.dsadmin;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import cnrg.itx.ds.*;
import edu.columbia.cs.itx.dsadmin.event.*;

public class DSManager implements ActionListener, DSAuthenticationListener {
  private DirectoryService ds;
  DSManagerMainFrame frame;
  TableSorter sorter;
  DSTableModel dataModel;
  DSAuthenticator authenticator;
  DSUserManager userManager;
  boolean loggedIn = false; // redundant, but may be of use in the future
  boolean dsInitialized = false; // is the ds initialized?

  public DSManager() {
    frame = new DSManagerMainFrame();
    frame.addWindowListener(new WindowAdapter() { public void windowClosing(WindowEvent e) { System.exit(0); } });
    sorter = new TableSorter();
    dataModel = new DSTableModel();
    sorter.setModel(dataModel);
    dataModel.addTableModelListener(sorter);
    frame.setTableModel(sorter);
    sorter.addMouseListenerToHeaderInTable(frame.getTable());
    sorter.addTableModelListener(frame.getTable());

    frame.addLoginActionListener(this);
    frame.addAddUserActionListener(userManager);
    frame.addRemoveUserActionListener(userManager);
    frame.addConfigMenuActionListener(new ConfigMenuObserver());
    setLogin(false);
    frame.setVisible(true);
  }

  public static void main(String[] args) {
    new DSManager();
  }

  // initialize the authenticator
  public void login() {
    try {
      authenticator = new DSAuthenticator(frame, frame.getTable(), ds);
      authenticator.addDSAuthenticationListener(this);
    } catch (DSAuthenticatorException e) {
      e.printStackTrace();
    }
  }

  // for the login button
  public void actionPerformed(ActionEvent e) {
    if (dsInitialized == true) {
      login();
    }
    else {
      String msg = "Please load a configuration file first.";
      JOptionPane.showMessageDialog(frame, msg, "Error: DirectoryService Not Initialized", JOptionPane.WARNING_MESSAGE);
    }
  }

  // authenticated
  public void dsAuthenticated(DSAuthenticationEvent e) {
    setLogin(true);
  }

  // adjust the buttons when logged in/out
  public void setLogin(boolean b) {
    loggedIn = b;
    frame.setLoginEnabled(!loggedIn);
    frame.setAddUserEnabled(loggedIn);
    frame.setRemoveUserEnabled(loggedIn);
    if (b == false)
      dataModel.setUsers(new Vector());
  }

  // set the ds and initialize a new user manager for the ds
  public void setDS(DirectoryService ds) {
    this.ds = ds;
    dsInitialized = true;
    try {
      frame.removeAddUserActionListener(userManager);
      frame.removeRemoveUserActionListener(userManager);
      userManager = new DSUserManager(frame, frame.getTable(), ds);
      frame.addAddUserActionListener(userManager);
      frame.addRemoveUserActionListener(userManager);
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(-1);
    }
  }

  // inner class to listen for events from the configuration file dialog
  class ConfigMenuObserver implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      String msg = "Please input the full path for the resolv.conf file.\n(e.g. C:\\ITX\\resolv.conf)";
      String path = JOptionPane.showInputDialog(frame, msg, "Configuration File Path", JOptionPane.QUESTION_MESSAGE);
      try {
        ds = new DirectoryService(path);
        setDS(ds);
        setLogin(false);
      } catch (DirectoryServiceException exp) {
        JOptionPane.showMessageDialog(frame, "Fail to load DirectoryService.", "Error: DirectoryService Load Failed", JOptionPane.WARNING_MESSAGE);
      }
    }
  }
}

